// config: norepeat

#include "GetObjects.js"
#include "GetPoint.js"

function DoOrientViewToView()
{
	var objectpicker = moi.ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'SourceViewPrompt' );
	moi.ui.showUI( 'OrientOptions' );
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'orient' );
	
	var pointpicker = moi.ui.createPointPicker();
	pointpicker.finishOnMouseDown = true;
	if ( !GetPoint( pointpicker ) )
		return;
		
	var srcframe = factory.getViewFrame( pointpicker );
	
	moi.ui.clearPickedPoints();
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SourceViewPrompt' );
	moi.ui.showUI( 'TargetViewPrompt' );
	moi.ui.endUIUpdate();

	if ( !GetPoint( pointpicker ) )
		return;
		
	var tarframe = factory.getViewFrame( pointpicker );

	factory.setInput( 0, objects );
	factory.setInput( 1, srcframe );
	factory.setInput( 2, tarframe );
	factory.setInput( 3, moi.ui.commandUI.MakeCopies.value );
	factory.commit();
}

DoOrientViewToView();
